---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：26-Pages Router

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **C-13**：クライアントサイドルーティングのJSON形式データプリフェッチの詳細実装根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModuleメイン実装
- E-02: `packages/next/src/server/render.tsx` - Pages Routerレンダリング
- E-03: `packages/next/src/server/route-modules/pages/pages-handler.ts` - リクエストハンドラ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PagesRouteModule.render()がrenderToHTMLImplに委譲 | E-01 (136-154行目) | ○ |
| C-02 | PagesUserlandModuleがdefault/config/getStaticProps/getStaticPaths/getServerSidePropsを定義 | E-01 (38-63行目) | ○ |
| C-03 | PagesComponentsにAppとDocumentコンポーネント | E-01 (70-82行目) | ○ |
| C-04 | getServerSidePropsとgetStaticPropsは排他的 | E-02 (573-575行目) | ○ |
| C-05 | getInitialPropsとgetServerSidePropsは排他的 | E-02 (569-570行目) | ○ |
| C-06 | isAutoExport判定ロジック | E-02 (547-551行目) | ○ |
| C-07 | 動的SSGページにgetStaticPathsが必須 | E-02 (596-601行目) | ○ |
| C-08 | 404/500ページでgetInitialProps/getServerSideProps不可 | E-02 (636-648行目) | ○ |
| C-09 | コンポーネントメンバーとしてのデータフェッチ関数は禁止 | E-02 (655-665行目) | ○ |
| C-10 | renderToHTMLImplでisSSG判定 | E-02 (519行目) | ○ |
| C-11 | 画面マッピングでエラーページ/ドキュメント/Appラッパーと関連 | E-05 | ○ |
| C-12 | vendoredContextsの統合 | E-01 (157-159行目) | ○ |
| C-13 | クライアントサイドナビゲーション時のJSON形式プリフェッチ | **根拠なし** (route-loader.ts未詳細確認) | △ |

## 4) 不足情報（Unknown / Missing）
- クライアントサイドナビゲーション時のJSON形式データ取得の具体的実装
  - 候補：`packages/next/src/client/route-loader.ts` / `packages/next/src/shared/lib/router/router.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PagesRouteModuleの構造は明確に確認済み
- 0: 低リスク - render.tsxの排他チェックは行番号レベルで確認済み
- 0: 低リスク - 画面マッピングとの整合性は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PagesRouteModule.render()からrenderToHTMLImplへの委譲が正確か確認
- [ ] 排他制約のエラーメッセージが最新か確認
- [ ] クライアントサイドルーティングのデータ取得メカニズムを確認
